// generated from rosidl_generator_c/resource/idl__struct.h.em
// with input from ds_dbw_msgs:msg/BrakeCmd.idl
// generated code does not contain a copyright notice

#ifndef DS_DBW_MSGS__MSG__DETAIL__BRAKE_CMD__STRUCT_H_
#define DS_DBW_MSGS__MSG__DETAIL__BRAKE_CMD__STRUCT_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>


// Constants defined in the message

/// Constant 'PRECHARGE_NONE'.
enum
{
  ds_dbw_msgs__msg__BrakeCmd__PRECHARGE_NONE = 0
};

/// Constant 'PRECHARGE_LEVEL_1'.
enum
{
  ds_dbw_msgs__msg__BrakeCmd__PRECHARGE_LEVEL_1 = 1
};

/// Constant 'PRECHARGE_LEVEL_2'.
enum
{
  ds_dbw_msgs__msg__BrakeCmd__PRECHARGE_LEVEL_2 = 2
};

/// Constant 'CMD_NONE'.
/**
  * Command types
  * Command  Rate-limit  Range     Note
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_NONE = 0
};

/// Constant 'CMD_PRESSURE'.
/**
  * bar      bar/s       0 to max  Pressure in bar
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_PRESSURE = 1
};

/// Constant 'CMD_TORQUE'.
/**
  * Nm       Nm/s        0 to max  Torque in Nm
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_TORQUE = 2
};

/// Constant 'CMD_ACCEL'.
/**
  * m/s^2    m/s^3       -10 to 5  Acceleration in m/s^2 using ACC with fallback to AEB for large magnitude
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_ACCEL = 8
};

/// Constant 'CMD_ACCEL_ACC'.
/**
  * m/s^2    m/s^3       -10 to 5  Acceleration in m/s^2 using ACC only
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_ACCEL_ACC = 9
};

/// Constant 'CMD_ACCEL_AEB'.
/**
  * m/s^2    m/s^3       -10 to 5  Acceleration in m/s^2 using AEB with fallback to ACC for extended duration
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_ACCEL_AEB = 10
};

/// Constant 'CMD_PEDAL_RAW'.
/**
  * %        %/s         0 to 100  Raw pedal sensor units
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_PEDAL_RAW = 13
};

/// Constant 'CMD_PERCENT'.
/**
  * %        %/s         0 to 100  Percent of maximum pressure/torque/decel
 */
enum
{
  ds_dbw_msgs__msg__BrakeCmd__CMD_PERCENT = 14
};

// Include directives for member types
// Member 'header'
#include "std_msgs/msg/detail/header__struct.h"

/// Struct defined in msg/BrakeCmd in the package ds_dbw_msgs.
typedef struct ds_dbw_msgs__msg__BrakeCmd
{
  std_msgs__msg__Header header;
  /// Brake command
  /// Command, changes with cmd_type
  float cmd;
  /// Rate limit for command increase, 0 for default, INFINITY for no limit, changes with cmd_type
  float rate_inc;
  /// Rate limit for command decrease, 0 for default, INFINITY for no limit, changes with cmd_type
  float rate_dec;
  uint8_t cmd_type;
  /// Enable
  bool enable;
  /// Clear latched overrides
  bool clear;
  /// Ignore future overrides
  bool ignore;
  /// Prechage AEB (only for platforms using ACC/AEB for braking)
  uint8_t precharge_aeb;
} ds_dbw_msgs__msg__BrakeCmd;

// Struct for a sequence of ds_dbw_msgs__msg__BrakeCmd.
typedef struct ds_dbw_msgs__msg__BrakeCmd__Sequence
{
  ds_dbw_msgs__msg__BrakeCmd * data;
  /// The number of valid items in data
  size_t size;
  /// The number of allocated items in data
  size_t capacity;
} ds_dbw_msgs__msg__BrakeCmd__Sequence;

#ifdef __cplusplus
}
#endif

#endif  // DS_DBW_MSGS__MSG__DETAIL__BRAKE_CMD__STRUCT_H_
