import launch
from launch_ros.actions import Node
from launch.actions import DeclareLaunchArgument
from launch.substitutions import LaunchConfiguration


def generate_launch_description():

    ### Manual composition of the image processing components
    lane_detection_pipeline = Node(
        package='dataspeed_dbw_gazebo_demo',
        namespace='vehicle/front_camera',
        executable='dataspeed_dbw_gazebo_demo_pipeline',
        parameters=[{
            'use_sim_time': True
        }],
        condition=launch.conditions.IfCondition(LaunchConfiguration('use_components'))
    )

    ### Separate processes for each image processing node
    lane_detection_node = Node(
        package='dataspeed_dbw_gazebo_demo',
        namespace='vehicle/front_camera',
        executable='dataspeed_dbw_gazebo_demo_lane_detection_node',
        parameters=[{
            'use_sim_time': True
        }],
        name='lane_detection',
        condition=launch.conditions.UnlessCondition(LaunchConfiguration('use_components'))
    )

    lane_fit_node = Node(
        package='dataspeed_dbw_gazebo_demo',
        namespace='vehicle/front_camera',
        executable='dataspeed_dbw_gazebo_demo_lane_fit_node',
        parameters=[{
            'use_sim_time': True
        }],
        name='lane_fit',
        condition=launch.conditions.UnlessCondition(LaunchConfiguration('use_components'))
    )

    lane_planner_node = Node(
        package='dataspeed_dbw_gazebo_demo',
        namespace='vehicle/front_camera',
        executable='dataspeed_dbw_gazebo_demo_lane_planner_node',
        parameters=[{
            'use_sim_time': True
        }],
        name='lane_planning',
        condition=launch.conditions.UnlessCondition(LaunchConfiguration('use_components'))
    )


    ### Standalone path following node
    path_following_node = Node(
        package='dataspeed_dbw_gazebo_demo',
        namespace='vehicle/front_camera',
        executable='dataspeed_dbw_gazebo_demo_path_following_node',
        parameters=[{
            'use_sim_time': True,
            'dbw2': LaunchConfiguration('dbw2')
        }],
        name='path_following',
    )

    enable_dbw = launch.actions.ExecuteProcess(
        cmd=['ros2', 'topic', 'pub', '/vehicle/enable', 'std_msgs/Empty'],
        output='log'
    )

    return launch.LaunchDescription([
        DeclareLaunchArgument('use_components', default_value='False', description='Run image processing pipeline in a container'),
        DeclareLaunchArgument('dbw2', default_value='True', description='Have lane following system output DBW 2 command messages'),
        lane_detection_pipeline,
        lane_detection_node,
        lane_fit_node,
        lane_planner_node,
        path_following_node,
        enable_dbw
    ])
