# generated from rosidl_generator_py/resource/_idl.py.em
# with input from ds_dbw_msgs:msg/GearReport.idl
# generated code does not contain a copyright notice

# This is being done at the module level and not on the instance level to avoid looking
# for the same variable multiple times on each instance. This variable is not supposed to
# change during runtime so it makes sense to only look for it once.
from os import getenv

ros_python_check_fields = getenv('ROS_PYTHON_CHECK_FIELDS', default='')


# Import statements for member types

import builtins  # noqa: E402, I100

import math  # noqa: E402, I100

import rosidl_parser.definition  # noqa: E402, I100


class Metaclass_GearReport(type):
    """Metaclass of message 'GearReport'."""

    _CREATE_ROS_MESSAGE = None
    _CONVERT_FROM_PY = None
    _CONVERT_TO_PY = None
    _DESTROY_ROS_MESSAGE = None
    _TYPE_SUPPORT = None

    __constants = {
    }

    @classmethod
    def __import_type_support__(cls):
        try:
            from rosidl_generator_py import import_type_support
            module = import_type_support('ds_dbw_msgs')
        except ImportError:
            import logging
            import traceback
            logger = logging.getLogger(
                'ds_dbw_msgs.msg.GearReport')
            logger.debug(
                'Failed to import needed modules for type support:\n' +
                traceback.format_exc())
        else:
            cls._CREATE_ROS_MESSAGE = module.create_ros_message_msg__msg__gear_report
            cls._CONVERT_FROM_PY = module.convert_from_py_msg__msg__gear_report
            cls._CONVERT_TO_PY = module.convert_to_py_msg__msg__gear_report
            cls._TYPE_SUPPORT = module.type_support_msg__msg__gear_report
            cls._DESTROY_ROS_MESSAGE = module.destroy_ros_message_msg__msg__gear_report

            from ds_dbw_msgs.msg import CmdSrc
            if CmdSrc.__class__._TYPE_SUPPORT is None:
                CmdSrc.__class__.__import_type_support__()

            from ds_dbw_msgs.msg import Gear
            if Gear.__class__._TYPE_SUPPORT is None:
                Gear.__class__.__import_type_support__()

            from ds_dbw_msgs.msg import GearReject
            if GearReject.__class__._TYPE_SUPPORT is None:
                GearReject.__class__.__import_type_support__()

            from std_msgs.msg import Header
            if Header.__class__._TYPE_SUPPORT is None:
                Header.__class__.__import_type_support__()

    @classmethod
    def __prepare__(cls, name, bases, **kwargs):
        # list constant names here so that they appear in the help text of
        # the message class under "Data and other attributes defined here:"
        # as well as populate each message instance
        return {
        }


class GearReport(metaclass=Metaclass_GearReport):
    """Message class 'GearReport'."""

    __slots__ = [
        '_header',
        '_gear',
        '_cmd',
        '_driver',
        '_reject',
        '_power_latched',
        '_external_control',
        '_ready',
        '_override_active',
        '_override_other',
        '_fault',
        '_bad_crc',
        '_degraded',
        '_actuator_temp',
        '_req_brake_cal',
        '_cmd_src',
        '_check_fields',
    ]

    _fields_and_field_types = {
        'header': 'std_msgs/Header',
        'gear': 'ds_dbw_msgs/Gear',
        'cmd': 'ds_dbw_msgs/Gear',
        'driver': 'ds_dbw_msgs/Gear',
        'reject': 'ds_dbw_msgs/GearReject',
        'power_latched': 'boolean',
        'external_control': 'boolean',
        'ready': 'boolean',
        'override_active': 'boolean',
        'override_other': 'boolean',
        'fault': 'boolean',
        'bad_crc': 'boolean',
        'degraded': 'boolean',
        'actuator_temp': 'float',
        'req_brake_cal': 'boolean',
        'cmd_src': 'ds_dbw_msgs/CmdSrc',
    }

    # This attribute is used to store an rosidl_parser.definition variable
    # related to the data type of each of the components the message.
    SLOT_TYPES = (
        rosidl_parser.definition.NamespacedType(['std_msgs', 'msg'], 'Header'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'Gear'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'Gear'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'Gear'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'GearReject'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'CmdSrc'),  # noqa: E501
    )

    def __init__(self, **kwargs):
        if 'check_fields' in kwargs:
            self._check_fields = kwargs['check_fields']
        else:
            self._check_fields = ros_python_check_fields == '1'
        if self._check_fields:
            assert all('_' + key in self.__slots__ for key in kwargs.keys()), \
                'Invalid arguments passed to constructor: %s' % \
                ', '.join(sorted(k for k in kwargs.keys() if '_' + k not in self.__slots__))
        from std_msgs.msg import Header
        self.header = kwargs.get('header', Header())
        from ds_dbw_msgs.msg import Gear
        self.gear = kwargs.get('gear', Gear())
        from ds_dbw_msgs.msg import Gear
        self.cmd = kwargs.get('cmd', Gear())
        from ds_dbw_msgs.msg import Gear
        self.driver = kwargs.get('driver', Gear())
        from ds_dbw_msgs.msg import GearReject
        self.reject = kwargs.get('reject', GearReject())
        self.power_latched = kwargs.get('power_latched', bool())
        self.external_control = kwargs.get('external_control', bool())
        self.ready = kwargs.get('ready', bool())
        self.override_active = kwargs.get('override_active', bool())
        self.override_other = kwargs.get('override_other', bool())
        self.fault = kwargs.get('fault', bool())
        self.bad_crc = kwargs.get('bad_crc', bool())
        self.degraded = kwargs.get('degraded', bool())
        self.actuator_temp = kwargs.get('actuator_temp', float())
        self.req_brake_cal = kwargs.get('req_brake_cal', bool())
        from ds_dbw_msgs.msg import CmdSrc
        self.cmd_src = kwargs.get('cmd_src', CmdSrc())

    def __repr__(self):
        typename = self.__class__.__module__.split('.')
        typename.pop()
        typename.append(self.__class__.__name__)
        args = []
        for s, t in zip(self.get_fields_and_field_types().keys(), self.SLOT_TYPES):
            field = getattr(self, s)
            fieldstr = repr(field)
            # We use Python array type for fields that can be directly stored
            # in them, and "normal" sequences for everything else.  If it is
            # a type that we store in an array, strip off the 'array' portion.
            if (
                isinstance(t, rosidl_parser.definition.AbstractSequence) and
                isinstance(t.value_type, rosidl_parser.definition.BasicType) and
                t.value_type.typename in ['float', 'double', 'int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64']
            ):
                if len(field) == 0:
                    fieldstr = '[]'
                else:
                    if self._check_fields:
                        assert fieldstr.startswith('array(')
                    prefix = "array('X', "
                    suffix = ')'
                    fieldstr = fieldstr[len(prefix):-len(suffix)]
            args.append(s + '=' + fieldstr)
        return '%s(%s)' % ('.'.join(typename), ', '.join(args))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        if self.header != other.header:
            return False
        if self.gear != other.gear:
            return False
        if self.cmd != other.cmd:
            return False
        if self.driver != other.driver:
            return False
        if self.reject != other.reject:
            return False
        if self.power_latched != other.power_latched:
            return False
        if self.external_control != other.external_control:
            return False
        if self.ready != other.ready:
            return False
        if self.override_active != other.override_active:
            return False
        if self.override_other != other.override_other:
            return False
        if self.fault != other.fault:
            return False
        if self.bad_crc != other.bad_crc:
            return False
        if self.degraded != other.degraded:
            return False
        if self.actuator_temp != other.actuator_temp:
            return False
        if self.req_brake_cal != other.req_brake_cal:
            return False
        if self.cmd_src != other.cmd_src:
            return False
        return True

    @classmethod
    def get_fields_and_field_types(cls):
        from copy import copy
        return copy(cls._fields_and_field_types)

    @builtins.property
    def header(self):
        """Message field 'header'."""
        return self._header

    @header.setter
    def header(self, value):
        if self._check_fields:
            from std_msgs.msg import Header
            assert \
                isinstance(value, Header), \
                "The 'header' field must be a sub message of type 'Header'"
        self._header = value

    @builtins.property
    def gear(self):
        """Message field 'gear'."""
        return self._gear

    @gear.setter
    def gear(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import Gear
            assert \
                isinstance(value, Gear), \
                "The 'gear' field must be a sub message of type 'Gear'"
        self._gear = value

    @builtins.property
    def cmd(self):
        """Message field 'cmd'."""
        return self._cmd

    @cmd.setter
    def cmd(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import Gear
            assert \
                isinstance(value, Gear), \
                "The 'cmd' field must be a sub message of type 'Gear'"
        self._cmd = value

    @builtins.property
    def driver(self):
        """Message field 'driver'."""
        return self._driver

    @driver.setter
    def driver(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import Gear
            assert \
                isinstance(value, Gear), \
                "The 'driver' field must be a sub message of type 'Gear'"
        self._driver = value

    @builtins.property
    def reject(self):
        """Message field 'reject'."""
        return self._reject

    @reject.setter
    def reject(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import GearReject
            assert \
                isinstance(value, GearReject), \
                "The 'reject' field must be a sub message of type 'GearReject'"
        self._reject = value

    @builtins.property
    def power_latched(self):
        """Message field 'power_latched'."""
        return self._power_latched

    @power_latched.setter
    def power_latched(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'power_latched' field must be of type 'bool'"
        self._power_latched = value

    @builtins.property
    def external_control(self):
        """Message field 'external_control'."""
        return self._external_control

    @external_control.setter
    def external_control(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'external_control' field must be of type 'bool'"
        self._external_control = value

    @builtins.property
    def ready(self):
        """Message field 'ready'."""
        return self._ready

    @ready.setter
    def ready(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'ready' field must be of type 'bool'"
        self._ready = value

    @builtins.property
    def override_active(self):
        """Message field 'override_active'."""
        return self._override_active

    @override_active.setter
    def override_active(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'override_active' field must be of type 'bool'"
        self._override_active = value

    @builtins.property
    def override_other(self):
        """Message field 'override_other'."""
        return self._override_other

    @override_other.setter
    def override_other(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'override_other' field must be of type 'bool'"
        self._override_other = value

    @builtins.property
    def fault(self):
        """Message field 'fault'."""
        return self._fault

    @fault.setter
    def fault(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'fault' field must be of type 'bool'"
        self._fault = value

    @builtins.property
    def bad_crc(self):
        """Message field 'bad_crc'."""
        return self._bad_crc

    @bad_crc.setter
    def bad_crc(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'bad_crc' field must be of type 'bool'"
        self._bad_crc = value

    @builtins.property
    def degraded(self):
        """Message field 'degraded'."""
        return self._degraded

    @degraded.setter
    def degraded(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'degraded' field must be of type 'bool'"
        self._degraded = value

    @builtins.property
    def actuator_temp(self):
        """Message field 'actuator_temp'."""
        return self._actuator_temp

    @actuator_temp.setter
    def actuator_temp(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'actuator_temp' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'actuator_temp' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._actuator_temp = value

    @builtins.property
    def req_brake_cal(self):
        """Message field 'req_brake_cal'."""
        return self._req_brake_cal

    @req_brake_cal.setter
    def req_brake_cal(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'req_brake_cal' field must be of type 'bool'"
        self._req_brake_cal = value

    @builtins.property
    def cmd_src(self):
        """Message field 'cmd_src'."""
        return self._cmd_src

    @cmd_src.setter
    def cmd_src(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import CmdSrc
            assert \
                isinstance(value, CmdSrc), \
                "The 'cmd_src' field must be a sub message of type 'CmdSrc'"
        self._cmd_src = value
