# generated from rosidl_generator_py/resource/_idl.py.em
# with input from ds_dbw_msgs:msg/EyeTracker.idl
# generated code does not contain a copyright notice

# This is being done at the module level and not on the instance level to avoid looking
# for the same variable multiple times on each instance. This variable is not supposed to
# change during runtime so it makes sense to only look for it once.
from os import getenv

ros_python_check_fields = getenv('ROS_PYTHON_CHECK_FIELDS', default='')


# Import statements for member types

import builtins  # noqa: E402, I100

import math  # noqa: E402, I100

import rosidl_parser.definition  # noqa: E402, I100


class Metaclass_EyeTracker(type):
    """Metaclass of message 'EyeTracker'."""

    _CREATE_ROS_MESSAGE = None
    _CONVERT_FROM_PY = None
    _CONVERT_TO_PY = None
    _DESTROY_ROS_MESSAGE = None
    _TYPE_SUPPORT = None

    __constants = {
        'GAZE_OTHER': 0,
        'GAZE_PASSENGER_WINDSHIELD': 1,
        'GAZE_DRIVER_WINDSHIELD': 2,
        'GAZE_INSTRUMENT_PANEL': 3,
        'GAZE_MEDIA_TABLET': 4,
        'GAZE_REAR_MIRROR': 6,
        'GAZE_DRIVER_MIRROR': 8,
        'GAZE_PASSENGER_MIRROR': 9,
        'GAZE_BELOW_DASHBOARD': 10,
    }

    @classmethod
    def __import_type_support__(cls):
        try:
            from rosidl_generator_py import import_type_support
            module = import_type_support('ds_dbw_msgs')
        except ImportError:
            import logging
            import traceback
            logger = logging.getLogger(
                'ds_dbw_msgs.msg.EyeTracker')
            logger.debug(
                'Failed to import needed modules for type support:\n' +
                traceback.format_exc())
        else:
            cls._CREATE_ROS_MESSAGE = module.create_ros_message_msg__msg__eye_tracker
            cls._CONVERT_FROM_PY = module.convert_from_py_msg__msg__eye_tracker
            cls._CONVERT_TO_PY = module.convert_to_py_msg__msg__eye_tracker
            cls._TYPE_SUPPORT = module.type_support_msg__msg__eye_tracker
            cls._DESTROY_ROS_MESSAGE = module.destroy_ros_message_msg__msg__eye_tracker

            from std_msgs.msg import Header
            if Header.__class__._TYPE_SUPPORT is None:
                Header.__class__.__import_type_support__()

    @classmethod
    def __prepare__(cls, name, bases, **kwargs):
        # list constant names here so that they appear in the help text of
        # the message class under "Data and other attributes defined here:"
        # as well as populate each message instance
        return {
            'GAZE_OTHER': cls.__constants['GAZE_OTHER'],
            'GAZE_PASSENGER_WINDSHIELD': cls.__constants['GAZE_PASSENGER_WINDSHIELD'],
            'GAZE_DRIVER_WINDSHIELD': cls.__constants['GAZE_DRIVER_WINDSHIELD'],
            'GAZE_INSTRUMENT_PANEL': cls.__constants['GAZE_INSTRUMENT_PANEL'],
            'GAZE_MEDIA_TABLET': cls.__constants['GAZE_MEDIA_TABLET'],
            'GAZE_REAR_MIRROR': cls.__constants['GAZE_REAR_MIRROR'],
            'GAZE_DRIVER_MIRROR': cls.__constants['GAZE_DRIVER_MIRROR'],
            'GAZE_PASSENGER_MIRROR': cls.__constants['GAZE_PASSENGER_MIRROR'],
            'GAZE_BELOW_DASHBOARD': cls.__constants['GAZE_BELOW_DASHBOARD'],
        }

    @property
    def GAZE_OTHER(self):
        """Message constant 'GAZE_OTHER'."""
        return Metaclass_EyeTracker.__constants['GAZE_OTHER']

    @property
    def GAZE_PASSENGER_WINDSHIELD(self):
        """Message constant 'GAZE_PASSENGER_WINDSHIELD'."""
        return Metaclass_EyeTracker.__constants['GAZE_PASSENGER_WINDSHIELD']

    @property
    def GAZE_DRIVER_WINDSHIELD(self):
        """Message constant 'GAZE_DRIVER_WINDSHIELD'."""
        return Metaclass_EyeTracker.__constants['GAZE_DRIVER_WINDSHIELD']

    @property
    def GAZE_INSTRUMENT_PANEL(self):
        """Message constant 'GAZE_INSTRUMENT_PANEL'."""
        return Metaclass_EyeTracker.__constants['GAZE_INSTRUMENT_PANEL']

    @property
    def GAZE_MEDIA_TABLET(self):
        """Message constant 'GAZE_MEDIA_TABLET'."""
        return Metaclass_EyeTracker.__constants['GAZE_MEDIA_TABLET']

    @property
    def GAZE_REAR_MIRROR(self):
        """Message constant 'GAZE_REAR_MIRROR'."""
        return Metaclass_EyeTracker.__constants['GAZE_REAR_MIRROR']

    @property
    def GAZE_DRIVER_MIRROR(self):
        """Message constant 'GAZE_DRIVER_MIRROR'."""
        return Metaclass_EyeTracker.__constants['GAZE_DRIVER_MIRROR']

    @property
    def GAZE_PASSENGER_MIRROR(self):
        """Message constant 'GAZE_PASSENGER_MIRROR'."""
        return Metaclass_EyeTracker.__constants['GAZE_PASSENGER_MIRROR']

    @property
    def GAZE_BELOW_DASHBOARD(self):
        """Message constant 'GAZE_BELOW_DASHBOARD'."""
        return Metaclass_EyeTracker.__constants['GAZE_BELOW_DASHBOARD']


class EyeTracker(metaclass=Metaclass_EyeTracker):
    """
    Message class 'EyeTracker'.

    Constants:
      GAZE_OTHER
      GAZE_PASSENGER_WINDSHIELD
      GAZE_DRIVER_WINDSHIELD
      GAZE_INSTRUMENT_PANEL
      GAZE_MEDIA_TABLET
      GAZE_REAR_MIRROR
      GAZE_DRIVER_MIRROR
      GAZE_PASSENGER_MIRROR
      GAZE_BELOW_DASHBOARD
    """

    __slots__ = [
        '_header',
        '_attention',
        '_gaze',
        '_eyes_present',
        '_check_fields',
    ]

    _fields_and_field_types = {
        'header': 'std_msgs/Header',
        'attention': 'float',
        'gaze': 'uint8',
        'eyes_present': 'boolean',
    }

    # This attribute is used to store an rosidl_parser.definition variable
    # related to the data type of each of the components the message.
    SLOT_TYPES = (
        rosidl_parser.definition.NamespacedType(['std_msgs', 'msg'], 'Header'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
    )

    def __init__(self, **kwargs):
        if 'check_fields' in kwargs:
            self._check_fields = kwargs['check_fields']
        else:
            self._check_fields = ros_python_check_fields == '1'
        if self._check_fields:
            assert all('_' + key in self.__slots__ for key in kwargs.keys()), \
                'Invalid arguments passed to constructor: %s' % \
                ', '.join(sorted(k for k in kwargs.keys() if '_' + k not in self.__slots__))
        from std_msgs.msg import Header
        self.header = kwargs.get('header', Header())
        self.attention = kwargs.get('attention', float())
        self.gaze = kwargs.get('gaze', int())
        self.eyes_present = kwargs.get('eyes_present', bool())

    def __repr__(self):
        typename = self.__class__.__module__.split('.')
        typename.pop()
        typename.append(self.__class__.__name__)
        args = []
        for s, t in zip(self.get_fields_and_field_types().keys(), self.SLOT_TYPES):
            field = getattr(self, s)
            fieldstr = repr(field)
            # We use Python array type for fields that can be directly stored
            # in them, and "normal" sequences for everything else.  If it is
            # a type that we store in an array, strip off the 'array' portion.
            if (
                isinstance(t, rosidl_parser.definition.AbstractSequence) and
                isinstance(t.value_type, rosidl_parser.definition.BasicType) and
                t.value_type.typename in ['float', 'double', 'int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64']
            ):
                if len(field) == 0:
                    fieldstr = '[]'
                else:
                    if self._check_fields:
                        assert fieldstr.startswith('array(')
                    prefix = "array('X', "
                    suffix = ')'
                    fieldstr = fieldstr[len(prefix):-len(suffix)]
            args.append(s + '=' + fieldstr)
        return '%s(%s)' % ('.'.join(typename), ', '.join(args))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        if self.header != other.header:
            return False
        if self.attention != other.attention:
            return False
        if self.gaze != other.gaze:
            return False
        if self.eyes_present != other.eyes_present:
            return False
        return True

    @classmethod
    def get_fields_and_field_types(cls):
        from copy import copy
        return copy(cls._fields_and_field_types)

    @builtins.property
    def header(self):
        """Message field 'header'."""
        return self._header

    @header.setter
    def header(self, value):
        if self._check_fields:
            from std_msgs.msg import Header
            assert \
                isinstance(value, Header), \
                "The 'header' field must be a sub message of type 'Header'"
        self._header = value

    @builtins.property
    def attention(self):
        """Message field 'attention'."""
        return self._attention

    @attention.setter
    def attention(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'attention' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'attention' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._attention = value

    @builtins.property
    def gaze(self):
        """Message field 'gaze'."""
        return self._gaze

    @gaze.setter
    def gaze(self, value):
        if self._check_fields:
            assert \
                isinstance(value, int), \
                "The 'gaze' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'gaze' field must be an unsigned integer in [0, 255]"
        self._gaze = value

    @builtins.property
    def eyes_present(self):
        """Message field 'eyes_present'."""
        return self._eyes_present

    @eyes_present.setter
    def eyes_present(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'eyes_present' field must be of type 'bool'"
        self._eyes_present = value
