# generated from rosidl_generator_py/resource/_idl.py.em
# with input from ds_dbw_msgs:msg/PropulsionInfo.idl
# generated code does not contain a copyright notice

# This is being done at the module level and not on the instance level to avoid looking
# for the same variable multiple times on each instance. This variable is not supposed to
# change during runtime so it makes sense to only look for it once.
from os import getenv

ros_python_check_fields = getenv('ROS_PYTHON_CHECK_FIELDS', default='')


# Import statements for member types

import builtins  # noqa: E402, I100

import math  # noqa: E402, I100

import rosidl_parser.definition  # noqa: E402, I100


class Metaclass_PropulsionInfo(type):
    """Metaclass of message 'PropulsionInfo'."""

    _CREATE_ROS_MESSAGE = None
    _CONVERT_FROM_PY = None
    _CONVERT_TO_PY = None
    _DESTROY_ROS_MESSAGE = None
    _TYPE_SUPPORT = None

    __constants = {
    }

    @classmethod
    def __import_type_support__(cls):
        try:
            from rosidl_generator_py import import_type_support
            module = import_type_support('ds_dbw_msgs')
        except ImportError:
            import logging
            import traceback
            logger = logging.getLogger(
                'ds_dbw_msgs.msg.PropulsionInfo')
            logger.debug(
                'Failed to import needed modules for type support:\n' +
                traceback.format_exc())
        else:
            cls._CREATE_ROS_MESSAGE = module.create_ros_message_msg__msg__propulsion_info
            cls._CONVERT_FROM_PY = module.convert_from_py_msg__msg__propulsion_info
            cls._CONVERT_TO_PY = module.convert_to_py_msg__msg__propulsion_info
            cls._TYPE_SUPPORT = module.type_support_msg__msg__propulsion_info
            cls._DESTROY_ROS_MESSAGE = module.destroy_ros_message_msg__msg__propulsion_info

            from ds_dbw_msgs.msg import Bool
            if Bool.__class__._TYPE_SUPPORT is None:
                Bool.__class__.__import_type_support__()

            from ds_dbw_msgs.msg import GearNum
            if GearNum.__class__._TYPE_SUPPORT is None:
                GearNum.__class__.__import_type_support__()

            from std_msgs.msg import Header
            if Header.__class__._TYPE_SUPPORT is None:
                Header.__class__.__import_type_support__()

    @classmethod
    def __prepare__(cls, name, bases, **kwargs):
        # list constant names here so that they appear in the help text of
        # the message class under "Data and other attributes defined here:"
        # as well as populate each message instance
        return {
        }


class PropulsionInfo(metaclass=Metaclass_PropulsionInfo):
    """Message class 'PropulsionInfo'."""

    __slots__ = [
        '_header',
        '_propulsion_torque_request',
        '_propulsion_torque_actual',
        '_gear_num_target',
        '_gear_num_actual',
        '_engine_torque_request',
        '_engine_torque_actual',
        '_transmission_ratio',
        '_torque_limiting',
        '_limp_home',
        '_check_fields',
    ]

    _fields_and_field_types = {
        'header': 'std_msgs/Header',
        'propulsion_torque_request': 'float',
        'propulsion_torque_actual': 'float',
        'gear_num_target': 'ds_dbw_msgs/GearNum',
        'gear_num_actual': 'ds_dbw_msgs/GearNum',
        'engine_torque_request': 'float',
        'engine_torque_actual': 'float',
        'transmission_ratio': 'float',
        'torque_limiting': 'ds_dbw_msgs/Bool',
        'limp_home': 'ds_dbw_msgs/Bool',
    }

    # This attribute is used to store an rosidl_parser.definition variable
    # related to the data type of each of the components the message.
    SLOT_TYPES = (
        rosidl_parser.definition.NamespacedType(['std_msgs', 'msg'], 'Header'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'GearNum'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'GearNum'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'Bool'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['ds_dbw_msgs', 'msg'], 'Bool'),  # noqa: E501
    )

    def __init__(self, **kwargs):
        if 'check_fields' in kwargs:
            self._check_fields = kwargs['check_fields']
        else:
            self._check_fields = ros_python_check_fields == '1'
        if self._check_fields:
            assert all('_' + key in self.__slots__ for key in kwargs.keys()), \
                'Invalid arguments passed to constructor: %s' % \
                ', '.join(sorted(k for k in kwargs.keys() if '_' + k not in self.__slots__))
        from std_msgs.msg import Header
        self.header = kwargs.get('header', Header())
        self.propulsion_torque_request = kwargs.get('propulsion_torque_request', float())
        self.propulsion_torque_actual = kwargs.get('propulsion_torque_actual', float())
        from ds_dbw_msgs.msg import GearNum
        self.gear_num_target = kwargs.get('gear_num_target', GearNum())
        from ds_dbw_msgs.msg import GearNum
        self.gear_num_actual = kwargs.get('gear_num_actual', GearNum())
        self.engine_torque_request = kwargs.get('engine_torque_request', float())
        self.engine_torque_actual = kwargs.get('engine_torque_actual', float())
        self.transmission_ratio = kwargs.get('transmission_ratio', float())
        from ds_dbw_msgs.msg import Bool
        self.torque_limiting = kwargs.get('torque_limiting', Bool())
        from ds_dbw_msgs.msg import Bool
        self.limp_home = kwargs.get('limp_home', Bool())

    def __repr__(self):
        typename = self.__class__.__module__.split('.')
        typename.pop()
        typename.append(self.__class__.__name__)
        args = []
        for s, t in zip(self.get_fields_and_field_types().keys(), self.SLOT_TYPES):
            field = getattr(self, s)
            fieldstr = repr(field)
            # We use Python array type for fields that can be directly stored
            # in them, and "normal" sequences for everything else.  If it is
            # a type that we store in an array, strip off the 'array' portion.
            if (
                isinstance(t, rosidl_parser.definition.AbstractSequence) and
                isinstance(t.value_type, rosidl_parser.definition.BasicType) and
                t.value_type.typename in ['float', 'double', 'int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64']
            ):
                if len(field) == 0:
                    fieldstr = '[]'
                else:
                    if self._check_fields:
                        assert fieldstr.startswith('array(')
                    prefix = "array('X', "
                    suffix = ')'
                    fieldstr = fieldstr[len(prefix):-len(suffix)]
            args.append(s + '=' + fieldstr)
        return '%s(%s)' % ('.'.join(typename), ', '.join(args))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        if self.header != other.header:
            return False
        if self.propulsion_torque_request != other.propulsion_torque_request:
            return False
        if self.propulsion_torque_actual != other.propulsion_torque_actual:
            return False
        if self.gear_num_target != other.gear_num_target:
            return False
        if self.gear_num_actual != other.gear_num_actual:
            return False
        if self.engine_torque_request != other.engine_torque_request:
            return False
        if self.engine_torque_actual != other.engine_torque_actual:
            return False
        if self.transmission_ratio != other.transmission_ratio:
            return False
        if self.torque_limiting != other.torque_limiting:
            return False
        if self.limp_home != other.limp_home:
            return False
        return True

    @classmethod
    def get_fields_and_field_types(cls):
        from copy import copy
        return copy(cls._fields_and_field_types)

    @builtins.property
    def header(self):
        """Message field 'header'."""
        return self._header

    @header.setter
    def header(self, value):
        if self._check_fields:
            from std_msgs.msg import Header
            assert \
                isinstance(value, Header), \
                "The 'header' field must be a sub message of type 'Header'"
        self._header = value

    @builtins.property
    def propulsion_torque_request(self):
        """Message field 'propulsion_torque_request'."""
        return self._propulsion_torque_request

    @propulsion_torque_request.setter
    def propulsion_torque_request(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'propulsion_torque_request' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'propulsion_torque_request' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._propulsion_torque_request = value

    @builtins.property
    def propulsion_torque_actual(self):
        """Message field 'propulsion_torque_actual'."""
        return self._propulsion_torque_actual

    @propulsion_torque_actual.setter
    def propulsion_torque_actual(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'propulsion_torque_actual' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'propulsion_torque_actual' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._propulsion_torque_actual = value

    @builtins.property
    def gear_num_target(self):
        """Message field 'gear_num_target'."""
        return self._gear_num_target

    @gear_num_target.setter
    def gear_num_target(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import GearNum
            assert \
                isinstance(value, GearNum), \
                "The 'gear_num_target' field must be a sub message of type 'GearNum'"
        self._gear_num_target = value

    @builtins.property
    def gear_num_actual(self):
        """Message field 'gear_num_actual'."""
        return self._gear_num_actual

    @gear_num_actual.setter
    def gear_num_actual(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import GearNum
            assert \
                isinstance(value, GearNum), \
                "The 'gear_num_actual' field must be a sub message of type 'GearNum'"
        self._gear_num_actual = value

    @builtins.property
    def engine_torque_request(self):
        """Message field 'engine_torque_request'."""
        return self._engine_torque_request

    @engine_torque_request.setter
    def engine_torque_request(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'engine_torque_request' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'engine_torque_request' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._engine_torque_request = value

    @builtins.property
    def engine_torque_actual(self):
        """Message field 'engine_torque_actual'."""
        return self._engine_torque_actual

    @engine_torque_actual.setter
    def engine_torque_actual(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'engine_torque_actual' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'engine_torque_actual' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._engine_torque_actual = value

    @builtins.property
    def transmission_ratio(self):
        """Message field 'transmission_ratio'."""
        return self._transmission_ratio

    @transmission_ratio.setter
    def transmission_ratio(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'transmission_ratio' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'transmission_ratio' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._transmission_ratio = value

    @builtins.property
    def torque_limiting(self):
        """Message field 'torque_limiting'."""
        return self._torque_limiting

    @torque_limiting.setter
    def torque_limiting(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import Bool
            assert \
                isinstance(value, Bool), \
                "The 'torque_limiting' field must be a sub message of type 'Bool'"
        self._torque_limiting = value

    @builtins.property
    def limp_home(self):
        """Message field 'limp_home'."""
        return self._limp_home

    @limp_home.setter
    def limp_home(self, value):
        if self._check_fields:
            from ds_dbw_msgs.msg import Bool
            assert \
                isinstance(value, Bool), \
                "The 'limp_home' field must be a sub message of type 'Bool'"
        self._limp_home = value
