# generated from rosidl_generator_py/resource/_idl.py.em
# with input from ds_dbw_msgs:msg/UlcReport.idl
# generated code does not contain a copyright notice

# This is being done at the module level and not on the instance level to avoid looking
# for the same variable multiple times on each instance. This variable is not supposed to
# change during runtime so it makes sense to only look for it once.
from os import getenv

ros_python_check_fields = getenv('ROS_PYTHON_CHECK_FIELDS', default='')


# Import statements for member types

import builtins  # noqa: E402, I100

import math  # noqa: E402, I100

import rosidl_parser.definition  # noqa: E402, I100


class Metaclass_UlcReport(type):
    """Metaclass of message 'UlcReport'."""

    _CREATE_ROS_MESSAGE = None
    _CONVERT_FROM_PY = None
    _CONVERT_TO_PY = None
    _DESTROY_ROS_MESSAGE = None
    _TYPE_SUPPORT = None

    __constants = {
    }

    @classmethod
    def __import_type_support__(cls):
        try:
            from rosidl_generator_py import import_type_support
            module = import_type_support('ds_dbw_msgs')
        except ImportError:
            import logging
            import traceback
            logger = logging.getLogger(
                'ds_dbw_msgs.msg.UlcReport')
            logger.debug(
                'Failed to import needed modules for type support:\n' +
                traceback.format_exc())
        else:
            cls._CREATE_ROS_MESSAGE = module.create_ros_message_msg__msg__ulc_report
            cls._CONVERT_FROM_PY = module.convert_from_py_msg__msg__ulc_report
            cls._CONVERT_TO_PY = module.convert_to_py_msg__msg__ulc_report
            cls._TYPE_SUPPORT = module.type_support_msg__msg__ulc_report
            cls._DESTROY_ROS_MESSAGE = module.destroy_ros_message_msg__msg__ulc_report

            from std_msgs.msg import Header
            if Header.__class__._TYPE_SUPPORT is None:
                Header.__class__.__import_type_support__()

    @classmethod
    def __prepare__(cls, name, bases, **kwargs):
        # list constant names here so that they appear in the help text of
        # the message class under "Data and other attributes defined here:"
        # as well as populate each message instance
        return {
        }


class UlcReport(metaclass=Metaclass_UlcReport):
    """Message class 'UlcReport'."""

    __slots__ = [
        '_header',
        '_cmd_type',
        '_vel_ref',
        '_vel_meas',
        '_accel_ref',
        '_accel_meas',
        '_coast_decel',
        '_ready',
        '_enabled',
        '_override_active',
        '_override_latched',
        '_preempted',
        '_timeout',
        '_bad_crc',
        '_bad_rc',
        '_check_fields',
    ]

    _fields_and_field_types = {
        'header': 'std_msgs/Header',
        'cmd_type': 'uint8',
        'vel_ref': 'float',
        'vel_meas': 'float',
        'accel_ref': 'float',
        'accel_meas': 'float',
        'coast_decel': 'boolean',
        'ready': 'boolean',
        'enabled': 'boolean',
        'override_active': 'boolean',
        'override_latched': 'boolean',
        'preempted': 'boolean',
        'timeout': 'boolean',
        'bad_crc': 'boolean',
        'bad_rc': 'boolean',
    }

    # This attribute is used to store an rosidl_parser.definition variable
    # related to the data type of each of the components the message.
    SLOT_TYPES = (
        rosidl_parser.definition.NamespacedType(['std_msgs', 'msg'], 'Header'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
        rosidl_parser.definition.BasicType('boolean'),  # noqa: E501
    )

    def __init__(self, **kwargs):
        if 'check_fields' in kwargs:
            self._check_fields = kwargs['check_fields']
        else:
            self._check_fields = ros_python_check_fields == '1'
        if self._check_fields:
            assert all('_' + key in self.__slots__ for key in kwargs.keys()), \
                'Invalid arguments passed to constructor: %s' % \
                ', '.join(sorted(k for k in kwargs.keys() if '_' + k not in self.__slots__))
        from std_msgs.msg import Header
        self.header = kwargs.get('header', Header())
        self.cmd_type = kwargs.get('cmd_type', int())
        self.vel_ref = kwargs.get('vel_ref', float())
        self.vel_meas = kwargs.get('vel_meas', float())
        self.accel_ref = kwargs.get('accel_ref', float())
        self.accel_meas = kwargs.get('accel_meas', float())
        self.coast_decel = kwargs.get('coast_decel', bool())
        self.ready = kwargs.get('ready', bool())
        self.enabled = kwargs.get('enabled', bool())
        self.override_active = kwargs.get('override_active', bool())
        self.override_latched = kwargs.get('override_latched', bool())
        self.preempted = kwargs.get('preempted', bool())
        self.timeout = kwargs.get('timeout', bool())
        self.bad_crc = kwargs.get('bad_crc', bool())
        self.bad_rc = kwargs.get('bad_rc', bool())

    def __repr__(self):
        typename = self.__class__.__module__.split('.')
        typename.pop()
        typename.append(self.__class__.__name__)
        args = []
        for s, t in zip(self.get_fields_and_field_types().keys(), self.SLOT_TYPES):
            field = getattr(self, s)
            fieldstr = repr(field)
            # We use Python array type for fields that can be directly stored
            # in them, and "normal" sequences for everything else.  If it is
            # a type that we store in an array, strip off the 'array' portion.
            if (
                isinstance(t, rosidl_parser.definition.AbstractSequence) and
                isinstance(t.value_type, rosidl_parser.definition.BasicType) and
                t.value_type.typename in ['float', 'double', 'int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64']
            ):
                if len(field) == 0:
                    fieldstr = '[]'
                else:
                    if self._check_fields:
                        assert fieldstr.startswith('array(')
                    prefix = "array('X', "
                    suffix = ')'
                    fieldstr = fieldstr[len(prefix):-len(suffix)]
            args.append(s + '=' + fieldstr)
        return '%s(%s)' % ('.'.join(typename), ', '.join(args))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        if self.header != other.header:
            return False
        if self.cmd_type != other.cmd_type:
            return False
        if self.vel_ref != other.vel_ref:
            return False
        if self.vel_meas != other.vel_meas:
            return False
        if self.accel_ref != other.accel_ref:
            return False
        if self.accel_meas != other.accel_meas:
            return False
        if self.coast_decel != other.coast_decel:
            return False
        if self.ready != other.ready:
            return False
        if self.enabled != other.enabled:
            return False
        if self.override_active != other.override_active:
            return False
        if self.override_latched != other.override_latched:
            return False
        if self.preempted != other.preempted:
            return False
        if self.timeout != other.timeout:
            return False
        if self.bad_crc != other.bad_crc:
            return False
        if self.bad_rc != other.bad_rc:
            return False
        return True

    @classmethod
    def get_fields_and_field_types(cls):
        from copy import copy
        return copy(cls._fields_and_field_types)

    @builtins.property
    def header(self):
        """Message field 'header'."""
        return self._header

    @header.setter
    def header(self, value):
        if self._check_fields:
            from std_msgs.msg import Header
            assert \
                isinstance(value, Header), \
                "The 'header' field must be a sub message of type 'Header'"
        self._header = value

    @builtins.property
    def cmd_type(self):
        """Message field 'cmd_type'."""
        return self._cmd_type

    @cmd_type.setter
    def cmd_type(self, value):
        if self._check_fields:
            assert \
                isinstance(value, int), \
                "The 'cmd_type' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'cmd_type' field must be an unsigned integer in [0, 255]"
        self._cmd_type = value

    @builtins.property
    def vel_ref(self):
        """Message field 'vel_ref'."""
        return self._vel_ref

    @vel_ref.setter
    def vel_ref(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'vel_ref' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'vel_ref' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._vel_ref = value

    @builtins.property
    def vel_meas(self):
        """Message field 'vel_meas'."""
        return self._vel_meas

    @vel_meas.setter
    def vel_meas(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'vel_meas' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'vel_meas' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._vel_meas = value

    @builtins.property
    def accel_ref(self):
        """Message field 'accel_ref'."""
        return self._accel_ref

    @accel_ref.setter
    def accel_ref(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'accel_ref' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'accel_ref' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._accel_ref = value

    @builtins.property
    def accel_meas(self):
        """Message field 'accel_meas'."""
        return self._accel_meas

    @accel_meas.setter
    def accel_meas(self, value):
        if self._check_fields:
            assert \
                isinstance(value, float), \
                "The 'accel_meas' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'accel_meas' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._accel_meas = value

    @builtins.property
    def coast_decel(self):
        """Message field 'coast_decel'."""
        return self._coast_decel

    @coast_decel.setter
    def coast_decel(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'coast_decel' field must be of type 'bool'"
        self._coast_decel = value

    @builtins.property
    def ready(self):
        """Message field 'ready'."""
        return self._ready

    @ready.setter
    def ready(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'ready' field must be of type 'bool'"
        self._ready = value

    @builtins.property
    def enabled(self):
        """Message field 'enabled'."""
        return self._enabled

    @enabled.setter
    def enabled(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'enabled' field must be of type 'bool'"
        self._enabled = value

    @builtins.property
    def override_active(self):
        """Message field 'override_active'."""
        return self._override_active

    @override_active.setter
    def override_active(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'override_active' field must be of type 'bool'"
        self._override_active = value

    @builtins.property
    def override_latched(self):
        """Message field 'override_latched'."""
        return self._override_latched

    @override_latched.setter
    def override_latched(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'override_latched' field must be of type 'bool'"
        self._override_latched = value

    @builtins.property
    def preempted(self):
        """Message field 'preempted'."""
        return self._preempted

    @preempted.setter
    def preempted(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'preempted' field must be of type 'bool'"
        self._preempted = value

    @builtins.property
    def timeout(self):
        """Message field 'timeout'."""
        return self._timeout

    @timeout.setter
    def timeout(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'timeout' field must be of type 'bool'"
        self._timeout = value

    @builtins.property
    def bad_crc(self):
        """Message field 'bad_crc'."""
        return self._bad_crc

    @bad_crc.setter
    def bad_crc(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'bad_crc' field must be of type 'bool'"
        self._bad_crc = value

    @builtins.property
    def bad_rc(self):
        """Message field 'bad_rc'."""
        return self._bad_rc

    @bad_rc.setter
    def bad_rc(self, value):
        if self._check_fields:
            assert \
                isinstance(value, bool), \
                "The 'bad_rc' field must be of type 'bool'"
        self._bad_rc = value
